/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.IncomingServiceRequest;
import com.ibm.hwmca.fw.bridge.request.Introspector;
import com.ibm.hwmca.fw.bridge.request.Signature;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class ReqCallMethod
extends IncomingServiceRequest {
    private static final String TRACE_MASKT = "XNBRJCMT";
    boolean staticMethodCall;
    String methodName;
    String signature;
    String objectNameOrClassName;
    Object[] arguments;
    Signature methodSignature;

    public boolean isRequestQuick() {
        return false;
    }

    public void readRequest() throws IOException {
        this.staticMethodCall = this.in.readBoolean();
        this.methodName = this.in.readUTF();
        this.signature = this.in.readUTF();
        this.objectNameOrClassName = this.in.readUTF();
        this.methodSignature = new Signature(this.signature, this.bridge);
        this.arguments = this.methodSignature.readArguments(this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void executeRequest() throws IOException {
        Object result;
        Method method;
        void var1_2;
        Class<?> targetClass;
        Object target = null;
        if (!this.staticMethodCall) {
            target = this.lookupRegisteredObject(this.objectNameOrClassName);
            if (target == null) {
                return;
            }
            targetClass = target.getClass();
        } else {
            try {
                targetClass = Class.forName(this.objectNameOrClassName);
            }
            catch (ClassNotFoundException e) {
                this.sendError(7, "Class " + this.objectNameOrClassName);
                return;
            }
        }
        try {
            method = Introspector.getMethod((Class)var1_2, this.methodName, this.methodSignature.getParameterClasses());
        }
        catch (NoSuchMethodException e) {
            this.sendError(3, this.methodName + " in class " + var1_2.getName());
            return;
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            this.sendError(5, "Lookup of method " + this.methodName + " in class " + var1_2.getName() + " raised exception: " + e);
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        if (this.staticMethodCall != Modifier.isStatic(method.getModifiers())) {
            this.sendError(this.staticMethodCall ? 9 : 8, this.methodName + " in class " + var1_2.getName());
            return;
        }
        if (!this.isReturnTypeValid(method)) {
            return;
        }
        try {
            Trace.trace(TRACE_MASKT, "Calling method " + this.methodName + " in class " + var1_2.getName());
            result = method.invoke(target, this.arguments);
            Trace.trace(TRACE_MASKT, "Return from method " + this.methodName + " in class " + var1_2.getName());
        }
        catch (IllegalAccessException e) {
            this.sendError(4, "Method " + this.methodName + " in class " + var1_2.getName());
            return;
        }
        catch (InvocationTargetException e) {
            this.sendError(5, "Method " + this.methodName + " in class " + var1_2.getName() + (this.staticMethodCall ? "" : " on object \"" + this.objectNameOrClassName + "\"") + " threw exception: " + e.getTargetException());
            Trace.trace(TRACE_MASKT, e.getTargetException());
            return;
        }
        Object object = this.getWriteLock();
        synchronized (object) {
            this.sendReply(result);
            this.out.flush();
        }
    }

    protected abstract boolean isReturnTypeValid(Method var1) throws IOException;

    protected abstract void sendReply(Object var1) throws IOException;
}

